<?php
// This must be the VERY FIRST LINE in the file
ob_start();
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', '/home/findyourfatecom/public_html/error_log');
ini_set('memory_limit', '256M');
clearstatcache();


$zodiac_signs = ['Aries', 'Taurus', 'Gemini', 'Cancer', 'Leo', 'Virgo', 
                 'Libra', 'Scorpio', 'Sagittarius', 'Capricorn', 'Aquarius', 'Pisces'];
$sign = isset($_GET['sign']) && in_array($_GET['sign'], $zodiac_signs) ? $_GET['sign'] : 'Aries';
$month = isset($_GET['month']) && is_numeric($_GET['month']) && $_GET['month'] >= 1 && $_GET['month'] <= 12 ? intval($_GET['month']) : date('n');
$year = isset($_GET['year']) && is_numeric($_GET['year']) && $_GET['year'] >= 1900 && $_GET['year'] <= 2100 ? intval($_GET['year']) : date('Y');


$month_name = date('F', mktime(0, 0, 0, $month, 1));
$month_year = "$month_name $year";


$safe_sign = htmlspecialchars($sign, ENT_QUOTES, 'UTF-8');
$safe_month_year = htmlspecialchars($month_year, ENT_QUOTES, 'UTF-8');


$page_title = "Astrological Calendar for $safe_sign - $safe_month_year - FindYourFate";
$meta_keywords = "astrology calendar, $safe_sign astrology, $safe_month_year astrology, moon phases, planetary transits, retrogrades, astrological events, $safe_sign horoscope, daily astrology, findyourfate";
$meta_description = "Discover your $safe_sign astrology calendar for $safe_month_year. Explore daily planetary transits, moon phases, retrogrades, and astrological events tailored to $safe_sign at FindYourFate.";
$canonical_url = "https://www.findyourfate.com/ai/astrology-calendar-fyf.php?sign=" . urlencode($sign) . "&month=$month&year=$year";




// Include database connection
if (!file_exists(__DIR__ . '/../includes/connection-db2.php')) {
    error_log("Database connection file not found: " . __DIR__ . '/../includes/connection-db2.php');
die("Error: Database configuration file not found.");
}
include __DIR__ . '/../includes/connection-db2.php';

if (!$pdo) {
    error_log("PDO connection failed");
    die("Error: Database connection failed.");
}

// Re-use functions from provided files
function getLocationFromIP() {
    $ip = $_SERVER['REMOTE_ADDR'];
    error_log("Detected IP: " . $ip);
    
    if ($ip === '127.0.0.1' || $ip === '::1') {
        error_log("Localhost detected, using Coimbatore as default");
        return [
            'city' => 'Coimbatore',
            'timezone' => 'Asia/Kolkata',
            'lat' => 11.0168,
            'lon' => 76.9558
        ];
    }

    $url = "http://ip-api.com/json/{$ip}?fields=city,timezone,lat,lon";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log("CURL error for ip-api.com: " . curl_error($ch));
    }
    curl_close($ch);

    if ($response !== false) {
        $data = json_decode($response, true);
        if ($data && !empty($data['city']) && !empty($data['timezone'])) {
            error_log("Location from ip-api.com: " . $data['city'] . ", " . $data['timezone']);
            if (strtolower($data['city']) === 'coimbatore') {
                return [
                    'city' => 'Coimbatore',
                    'timezone' => $data['timezone'],
                    'lat' => 11.0168,
                    'lon' => 76.9558
                ];
            }
            return [
                'city' => $data['city'],
                'timezone' => $data['timezone'],
                'lat' => $data['lat'],
                'lon' => $data['lon']
            ];
        }
    }

    error_log("Both APIs failed, falling back to Coimbatore");
    return [
        'city' => 'Coimbatore',
        'timezone' => 'Asia/Kolkata',
        'lat' => 11.0168,
        'lon' => 76.9558
    ];
}

function getZodiacName($abbr) {
    $zodiacMap = [
        'AR' => 'Aries', 'TA' => 'Taurus', 'GE' => 'Gemini', 'CN' => 'Cancer', 
        'LE' => 'Leo', 'VI' => 'Virgo', 'LI' => 'Libra', 'SC' => 'Scorpio', 
        'SG' => 'Sagittarius', 'CP' => 'Capricorn', 'AQ' => 'Aquarius', 'PI' => 'Pisces'
    ];
    return $zodiacMap[$abbr] ?? 'Unknown';
}

function getZodiacSymbol($zodiac) {
    $symbols = [
        'Aries' => '♈', 'Taurus' => '♉', 'Gemini' => '♊', 'Cancer' => '♋', 
        'Leo' => '♌', 'Virgo' => '♍', 'Libra' => '♎', 'Scorpio' => '♏', 
        'Sagittarius' => '♐', 'Capricorn' => '♑', 'Aquarius' => '♒', 'Pisces' => '♓'
    ];
    return $symbols[$zodiac] ?? '';
}

function getZodiacAbbreviation($zodiac) {
    $zodiacMap = [
        'Aries' => 'AR', 'Taurus' => 'TA', 'Gemini' => 'GE', 'Cancer' => 'CN', 
        'Leo' => 'LE', 'Virgo' => 'VI', 'Libra' => 'LI', 'Scorpio' => 'SC', 
        'Sagittarius' => 'SG', 'Capricorn' => 'CP', 'Aquarius' => 'AQ', 'Pisces' => 'PI'
    ];
    return $zodiacMap[$zodiac] ?? 'Unknown';
}

function calculateAspects($planet_positions) {
    $aspects = [];
    $aspect_types = [
        'Conjunction' => [0, 6], 'Opposition' => [180, 6], 
        'Square' => [90, 5], 'Trine' => [120, 5], 
        'Sextile' => [60, 4]
    ];

    $planets = array_keys($planet_positions);
    $personal_planets = ['Sun', 'Moon', 'Mercury', 'Venus', 'Mars'];
    
    for ($i = 0; $i < count($planets) - 1; $i++) {
        for ($j = $i + 1; $j < count($planets); $j++) {
            if (!in_array($planets[$i], $personal_planets) && 
                !in_array($planets[$j], $personal_planets)) continue;
            
            $deg1 = $planet_positions[$planets[$i]]['abs_deg'];
            $deg2 = $planet_positions[$planets[$j]]['abs_deg'];
            $diff = abs($deg1 - $deg2);
            $diff = min($diff, 360 - $diff);

            foreach ($aspect_types as $type => $data) {
                list($angle, $orb) = $data;
                if (abs($diff - $angle) <= $orb) {
                    $aspects[] = [
                        'type' => $type,
                        'planet1' => $planets[$i],
                        'planet2' => $planets[$j],
                        'orb' => round(abs($diff - $angle), 2)
                    ];
                }
            }
        }
    }
    return $aspects;
}

// Handle user input
$zodiac_signs = ['Aries', 'Taurus', 'Gemini', 'Cancer', 'Leo', 'Virgo', 
                 'Libra', 'Scorpio', 'Sagittarius', 'Capricorn', 'Aquarius', 'Pisces'];

$sign = isset($_GET['sign']) && in_array($_GET['sign'], $zodiac_signs) ? $_GET['sign'] : 'Aries';
$month = isset($_GET['month']) && is_numeric($_GET['month']) && $_GET['month'] >= 1 && $_GET['month'] <= 12 ? intval($_GET['month']) : date('n');
$year = isset($_GET['year']) && is_numeric($_GET['year']) && $_GET['year'] >= 1900 && $_GET['year'] <= 2100 ? intval($_GET['year']) : date('Y');

$location_data = getLocationFromIP();
$timezone = isset($_GET['timezone']) ? trim($_GET['timezone']) : $location_data['timezone'];
// Set PHP default timezone to user timezone
date_default_timezone_set($timezone);
$location = isset($_GET['location']) ? trim($_GET['location']) : $location_data['city'];
$latitude = $location_data['lat'];
$longitude = $location_data['lon'];

// Calculate days in month
$days_in_month = cal_days_in_month(CAL_GREGORIAN, $month, $year);
$first_day = new DateTime("$year-$month-01", new DateTimeZone($timezone));
$first_day_weekday = $first_day->format('N') - 1; // 0 (Monday) to 6 (Sunday)

// Emoji logic for daily ratings
function getDailyEmojis($date, $sign, $planet_positions, $aspects) {
    $emojis = [];
    $descriptions = [];
    
    $sun_sign = $planet_positions['Sun']['zodiac'];
    $moon_sign = $planet_positions['Moon']['zodiac'];
    
    // Check if Sun is in the selected sign
    if ($sun_sign === $sign) {
        $emojis[] = '😊';
        $descriptions[] = "The Sun in $sign boosts your vitality and confidence.";
    }
    
    // Moon aspects and position
    if ($moon_sign === $sign || $moon_sign === 'Gemini' || $moon_sign === 'Leo') {
        $emojis[] = '😂';
        $descriptions[] = "The Moon in $moon_sign sparks fun and social vibes.";
    }
    
    // Analyze aspects
    foreach ($aspects as $aspect) {
        $planet1 = $aspect['planet1'];
        $planet2 = $aspect['planet2'];
        $type = $aspect['type'];
        
        // Good day / Well-being
        if (($planet1 === 'Moon' && $planet2 === 'Sun' && $type === 'Trine') ||
            ($planet1 === 'Venus' && $type === 'Trine') ||
            ($planet1 === 'Jupiter' && in_array($type, ['Trine', 'Sextile']))) {
            $emojis[] = '😊';
            $descriptions[] = "$planet1 $type $planet2 brings harmony and optimism.";
        }
        
        // Love day
        if ($planet1 === 'Venus' && in_array($type, ['Trine', 'Sextile'])) {
            $emojis[] = '😍';
            $descriptions[] = "$planet1 $type $planet2 enhances romance and connection.";
        } elseif ($planet1 === 'Venus' && $planet2 === 'Mars' && $type === 'Opposition') {
            $emojis[] = '💔';
            $descriptions[] = "$planet1 $type $planet2 may stir romantic tension.";
        }
        
        // Money/Opportunity day
        if (($planet1 === 'Jupiter' && in_array($type, ['Trine', 'Sextile'])) ||
            ($planet1 === 'Venus' && $type === 'Sextile') ||
            ($planet1 === 'Mercury' && $planet2 === 'Saturn' && $type === 'Sextile')) {
            $emojis[] = '🤑';
            $descriptions[] = "$planet1 $type $planet2 opens doors for prosperity.";
        }
        
        // Confusion/Stress
        if (($planet1 === 'Mercury' && $planet2 === 'Neptune' && $type === 'Square') ||
            ($planet1 === 'Mars' && $planet2 === 'Moon' && $type === 'Square')) {
            $emojis[] = '😕';
            $descriptions[] = "$planet1 $type $planet2 may cause confusion or tension.";
        }
        
        // Emotional challenges
        if ($planet1 === 'Moon' && $planet2 === 'Saturn' && $type === 'Square') {
            $emojis[] = '💔';
            $descriptions[] = "$planet1 $type $planet2 could bring emotional hurdles.";
        }
    }
    
    // Retrograde check
    if (isset($planet_positions['Mercury']['retrograde']) && $planet_positions['Mercury']['retrograde']) {
        $emojis[] = '😕';
        $descriptions[] = "Mercury retrograde suggests caution in communication.";
    }
    
    return ['emojis' => array_unique($emojis), 'descriptions' => $descriptions];
}

// Generate daily data
$daily_data = [];
for ($day = 1; $day <= $days_in_month; $day++) {
    $date = sprintf("%04d-%02d-%02d", $year, $month, $day);

    // Convert local midnight to UTC date for ephemeris lookup
    $dtLocal = new DateTime("$year-$month-$day 00:00:00", new DateTimeZone($timezone));
    $dtLocal->setTimezone(new DateTimeZone('UTC'));
    list($yUtc, $mUtc, $dUtc) = explode('-', $dtLocal->format('Y-m-d'));

    // Fetch ephemeris data
    try {
        $query = "SELECT econtent FROM ephemeris WHERE eyear = ? AND emonth = ? AND eday = ?";
        $stmt = $pdo->prepare($query);
        $stmt->execute([$yUtc, $mUtc, $dUtc]);
        $ephemeris_data = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$ephemeris_data) {
            error_log("No ephemeris data for date: $date");
            $daily_data[$day] = ['emojis' => [], 'descriptions' => []];
            continue;
        }

        $econtent = $ephemeris_data['econtent'];
        $econtent_parts = explode(" ", trim($econtent));
    } catch (Exception $e) {
        error_log("Ephemeris query error for $date: " . $e->getMessage());
        $daily_data[$day] = ['emojis' => [], 'descriptions' => []];
        continue;
    }

    // Parse planet positions
    $planets = ['Sun', 'Moon', 'Mercury', 'Venus', 'Mars', 'Jupiter', 'Saturn', 'Uranus', 'Neptune', 'Pluto'];
    $planet_positions = [];
    for ($i = 0; $i < count($planets); $i++) {
        if (isset($econtent_parts[$i + 1]) && preg_match('/(\d+)([A-Z]{2})(\d+)/', $econtent_parts[$i + 1], $matches)) {
            $degree = $matches[1];
            $zodiac = strtoupper($matches[2]);
            $planet_positions[$planets[$i]] = [
                'degree' => $degree,
                'zodiac' => getZodiacName($zodiac),
                'abs_deg' => (array_search($zodiac, array_keys(['AR' => 'Aries', 'TA' => 'Taurus', 'GE' => 'Gemini', 'CN' => 'Cancer', 
                    'LE' => 'Leo', 'VI' => 'Virgo', 'LI' => 'Libra', 'SC' => 'Scorpio', 
                    'SG' => 'Sagittarius', 'CP' => 'Capricorn', 'AQ' => 'Aquarius', 'PI' => 'Pisces'])) * 30) + intval($degree),
                'retrograde' => false // Assuming no retrograde data in econtent; extend if available
            ];
        }
    }

    // Calculate aspects
    $aspects = calculateAspects($planet_positions);
    
    // Get emojis and descriptions
    $daily_data[$day] = getDailyEmojis($date, $sign, $planet_positions, $aspects);
}

// Emoji legend
$emoji_legend = [
    '😊' => 'Good day / General well-being',
    '😍' => 'Love day',
    '🤑' => 'Money/Opportunity day',
    '😕' => 'Confusion/Stress',
    '😂' => 'Fun/Social day',
    '💔' => 'Emotional challenges'
];

// Output HTML
?>
<!DOCTYPE html>
<html lang="en">
<head>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Arial', sans-serif;
        }
        body {
            margin-top: -20px;
            color: #fff;
            line-height: 1.6;
            padding: 20px;
             width: 100%;
    max-width: 100vw;
    overflow-x: hidden;
        }
        .container1 {
            width:100%;
            max-width: 1000px;
            margin: 0 auto;
            background: rgba(0, 0, 0, 0.7);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(255, 255, 255, 0.1);
        }
        h2 {
            color: #e94560;
            font-size: 25px;
            margin-bottom: 20px;
            text-align: center;
        }
        h1 {
            color: #e94560;
            font-size: 2em;
            margin-bottom: 20px;
            text-align: center;
        }
        .form-container {
            margin-bottom: 20px;
            text-align: center;
        }
        .form-container select, .form-container input {
            padding: 8px;
            border-radius: 5px;
            background: #333;
            color: white;
            border: 1px solid #555;
            margin: 5px;
        }
        .form-container input[type="submit"] {
            background: #e94560;
            border: none;
            cursor: pointer;
        }
        .form-container input[type="submit"]:hover {
            background: #d13454;
        }
        .calendar {
            display: grid;
            grid-template-columns: repeat(7, 1fr);
            gap: 5px;
            margin-top: 20px;
        }
        .calendar div {
            background: rgba(30, 30, 50, 0.5);
            padding: 10px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            text-align: center;
            min-height: 80px;
        }
        .calendar .header {
    background: #e94560;
    font-weight: bold;
    border: 1px solid #e94560;
    text-align: center;
    font-size: 0.95em;
    padding: 8px 4px;
    height: 38px;
    line-height: 1.2;
    display: flex;
    align-items: center;
    justify-content: center;
    white-space: nowrap; /* ✅ prevent breaking into two lines */
    overflow: hidden;     /* ✅ prevent overflow outside cell */
    text-overflow: ellipsis; /* ✅ truncate cleanly if needed */
}


        .calendar .day {
            cursor: pointer;
            position: relative;
        }
        .calendar .day:hover {
            background: rgba(50, 50, 70, 0.7);
        }
        .emojis {
            font-size: 1.2em;
            margin-top: 5px;
        }
        .empty {
            background: rgba(10, 10, 20, 0.3);
            border: none;
        }
        .legend {
            margin-top: 20px;
            padding: 10px;
            background: rgba(30, 30, 50, 0.5);
            border-radius: 5px;
        }
        .legend h3 {
            color: #e94560;
            margin-bottom: 10px;
        }
        .legend p {
            margin: 5px 0;
        }
        .note {
            margin-top: 10px;
            font-style: italic;
            color: #ccc;
            text-align: center;
        }
        .description-box {
            margin-top: 20px;
            padding: 10px;
            background: rgba(30, 30, 50, 0.5);
            border-radius: 5px;
            min-height: 100px;
        }
        .description-box h3 {
            color: #e94560;
            margin-bottom: 10px;
        }
        @media (max-width: 600px) {
    .calendar {
        grid-template-columns: repeat(7, 1fr);
    }

    .calendar div {
        padding: 5px;
        min-height: 60px;
        font-size: 0.8em;
    }

    .calendar .header {
        font-size: 0.75em;
        padding: 6px 2px;
        height: 34px;
    }
}


        @media (max-width: 600px) {
            .calendar {
                grid-template-columns: repeat(7, 1fr);
            }
            .calendar div {
                padding: 5px;
                min-height: 60px;
                border: 1px solid rgba(255, 255, 255, 0.2); /* Ensure borders on mobile */
            }
            .calendar .header {
                font-size: 0.9em;
            }
            .emojis {
                font-size: 1em;
            }
            .description-box {
                font-size: 0.9em;
            }
        }
        /* Add a more specific media query for smaller screens (iPhone-specific) */
@media (max-width: 600px) {
    .calendar {
        grid-template-columns: repeat(7, 1fr); /* Ensure 7 columns */
        gap: 3px; /* Reduce gap to save space */
        width: 100%; /* Ensure calendar takes full width */
        max-width: 100vw; /* Prevent overflow */
    }

    .calendar div {
        padding: 4px; /* Reduce padding for more space */
        min-height: 50px; /* Slightly smaller cells for smaller screens */
        font-size: 0.75em; /* Smaller font size for better fit */
        border: 1px solid rgba(255, 255, 255, 0.2); /* Keep borders */
    }

    .calendar .header {
        font-size: 0.65em; /* Further reduce header font size */
        padding: 4px 2px; /* Reduce padding */
        height: 30px; /* Smaller height for headers */
        line-height: 1.1; /* Adjust line height */
        white-space: normal; /* Allow text wrapping to prevent overflow */
        overflow: hidden; /* Hide overflow */
        text-overflow: ellipsis; /* Truncate if needed */
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .emojis {
        font-size: 0.9em; /* Slightly smaller emojis */
    }

    .description-box {
        font-size: 0.85em; /* Adjust description font size */
    }
}

/* Add a more specific media query for very small screens (e.g., iPhone SE) */
@media (max-width: 375px) {
    .calendar {
        gap: 2px; /* Further reduce gap */
    }

    .calendar div {
        padding: 3px; /* Further reduce padding */
        min-height: 45px; /* Smaller cells */
        font-size: 0.7em; /* Smaller font */
    }

    .calendar .header {
        font-size: 0.6em; /* Even smaller header font */
        padding: 3px 1px; /* Minimal padding */
        height: 28px; /* Smaller height */
    }
}

    </style>
</head>
<body>



    <div class="container1">
        <h2>Astrological Calendar for <?php echo $sign; ?> - <?php echo date('F Y', strtotime("$year-$month-01")); ?></h2>
        
        <div class="form-container">
            <form method="get">
                <select name="sign">
                    <?php foreach ($zodiac_signs as $z_sign): ?>
                        <option value="<?php echo $z_sign; ?>" <?php echo $z_sign === $sign ? 'selected' : ''; ?>><?php echo $z_sign; ?></option>
                    <?php endforeach; ?>
                </select>
                <select name="month">
                    <?php for ($m = 1; $m <= 12; $m++): ?>
                        <option value="<?php echo $m; ?>" <?php echo $m === $month ? 'selected' : ''; ?>><?php echo date('F', mktime(0, 0, 0, $m, 1)); ?></option>
                    <?php endfor; ?>
                </select>
                <input type="number" name="year" value="<?php echo $year; ?>" min="1900" max="2100">
                <input type="submit" value="Generate Calendar">
            </form>
        </div>

        <div class="calendar">
            <div class="header">Mon</div>
            <div class="header">Tue</div>
            <div class="header">Wed</div>
            <div class="header">Thu</div>
            <div class="header">Fri</div>
            <div class="header">Sat</div>
            <div class="header">Sun</div>
            
            <?php
            // Add empty cells for days before the first of the month
            for ($i = 0; $i < $first_day_weekday; $i++) {
                echo '<div class="empty"></div>';
            }
            
            // Generate calendar days
            for ($day = 1; $day <= $days_in_month; $day++) {
                $emojis = isset($daily_data[$day]['emojis']) ? implode('', $daily_data[$day]['emojis']) : '';
                $descriptions = isset($daily_data[$day]['descriptions']) ? implode('<br>', $daily_data[$day]['descriptions']) : 'No significant aspects today.';
                
                echo "<div class=\"day\" onclick=\"showDescription('$day', '$descriptions')\">";
                echo "<strong>$day</strong>";
                echo '<div class="emojis">' . ($emojis ?: ' ') . '</div>';
                echo '</div>';
            }
            
            // Add empty cells to complete the grid
            $last_day_weekday = (new DateTime("$year-$month-$days_in_month", new DateTimeZone($timezone)))->format('N') - 1;
            $remaining_cells = (7 - (($first_day_weekday + $days_in_month) % 7)) % 7;
            for ($i = 0; $i < $remaining_cells; $i++) {
                echo '<div class="empty"></div>';
            }
            ?>
        </div>

        <div class="note">
            Click on a date to view its astrological description below.
        </div>

        <div class="legend">
            <h3>Emoji Legend</h3>
            <?php foreach ($emoji_legend as $emoji => $meaning): ?>
                <p><?php echo $emoji; ?> - <?php echo $meaning; ?></p>
            <?php endforeach; ?>
        </div>

        <div class="description-box" id="description-box">
            <h3>Selected Date Description</h3>
            <p>Select a date to see its astrological influences.</p>
        </div>
    </div>

    <script>
        function showDescription(day, descriptions) {
            const descriptionBox = document.getElementById('description-box');
            descriptionBox.innerHTML = `
                <h3>Description for ${day} <?php echo date('F Y', strtotime("$year-$month-01")); ?></h3>
                <p>${descriptions || 'No significant aspects today.'}</p>
            `;
        }
    </script>
</body>
</html>
<?php
ob_end_flush();
?>
